## 用DeepSeek做小红书真的太牛了！轻轻松松打造爆款笔记


最近，DeepSeek火出圈了，不仅在人工智能行业带来一场海啸，还在其他各个行业掀起了应用热潮，连官媒也在用DeepSeek创作素材，那么**这个DeepSeek到底是个啥？又能帮助小红书博主做什么？这篇文章我们就来详细介绍一下如何使用DeepSeek做小红书。**

DeepSeek，是一款 **AI 助手应用**，也就是ChatGPT、OpenAI、豆包和Kimi的同行，于2025年1月11日正式上线，官网网站网址为：**https://www.deepseek.com/**。可以使用网页访问，也能在各大应用商店下载安装应用。

![img](https://pic.yupi.icu/yuyi/1739499899144-b2353868-b157-4249-b669-884871589235.webp)

在做小红书方面，DeepSeek能够实现多个目标，包括但不限于**搭建选题、收集资料、写标题、写文案、做图片、数据分析和账号运营。**

**那么小红书博主应该如何向DeepSeek提问？有哪些注意事项？流程是怎么样的？**

接下来我们就详细为大家介绍。

## 搭建选题

**用DeepSeek来找小红书笔记选题，提问不能太过宽泛，例如“最近有什么美妆热点话题？”**  这样的问题涵盖的范围是非常广的，有整个行业的动态、市场趋势分析，这对于一个小红书美妆博主来说根本无法直接使用，还得自己去深挖、和自己的定位等等联系，找选题。

![img](https://pic.yupi.icu/yuyi/1739499899141-d2b1b51d-0bc7-420a-8d38-f671c7e2d25f.webp)

### 应该怎么问？

**增加自己账号的目标与定位，包括所属类目、目标受众、笔记内容、风格等等，因为只有足够了解自己，才能将这些信息作为“背景信息”输入，得到最匹配的选题建议。**

除此之外，**背景信息** 还可以加入 **时间（春节期间、夏季）、地域限制（浙江、杭州）、选题来源（各大信息资源库）** 等等。

例如下图我测试的这个问题，**“小红书护肤博主，白皮敏感肌，面向的主要是年轻女性用户，在春季来临时可以做哪些选题？”** 这个问题里就包含了相当详细和全面的背景信息，这有利于模型输出最匹配的选题，可实行性也非常高，比如“春节敏感肌急救方法”、“春季护肤品测评”、“春季敏感肌护肤流程”等等。

![img](https://pic.yupi.icu/yuyi/1739499899587-3d323d38-156e-4f18-a40a-c2a483488879.webp)

## 收集、整理资料&素材

**AI 就像一个巨大的资料库入口，从中我们可以窥见它包含的所有信息数据，利用DeepSeek，就可以在搜集资料素材环节节省不少时间和精力。**

不过目前DeepSeek的知识截止日期是 **2024年7月**，所以当你问它“近期……”，它很有可能给你整一个去年的东西出来，但**选择“联网搜索”，还是可以获取实时信息的。**

![img](https://pic.yupi.icu/yuyi/1739499899631-cd65c785-0b4d-4017-a1dd-bc98b3bb9d05.webp)

在找资料时，不要过于简洁和笼统，例如“怎么备考教资？”，可能你想的是它为你介绍需要购买哪些备考资料，但是范围过大，会将其他的内容，比如备考计划、考试信息都房子里面，资料就不够详细和全面了。

### 应该怎么问？

**尽量把需要搜集的信息描述地详细和明确，例如限定资料来源、信息发布时间范围、发布者等等；同时加入背景信息，告诉模型你的这些资料和信息是用在什么地方，需要达成的效果、实现的目标等等，能够获得更加精确和全面的资料信息。**

例如下图的对话，**“我是小红书心理博主，想要做一个抑郁症主题的笔记，内容包括抑郁症的病因，抑郁症的患病人数，抑郁症的常见病症，治愈抑郁症的方法这几项内容，请帮我搜集官方网站发布的最新数据和一些相关文献以支撑。”** 模型就按要求给出了数据，并且加入在笔记大纲中，非常完成和顺畅，数据来源也非常清晰。

![img](https://pic.yupi.icu/yuyi/1739499899629-225584d1-eea9-454e-b50a-8092084c94f3.webp)

**如果你想做一个选题，但是不知道选题中需要哪些资料，你也可以直接向DeepSeek提问，我想做一个xxx笔记，实现xxx的目标，需要准备哪些资料和信息？**

例如下面的这个婴儿车测评笔记所需资料和理论知识，模型就全部列出，并且还能点击网页链接一键跳转数据来源平台。

![img](https://pic.yupi.icu/yuyi/1739499899620-cb5cb6b9-2ed4-422d-b96e-0f53dd05029c.webp)

## 写标题

众所周知标题是决定点击率的最重要因素之一，当你写不出一个好的标题时，可以用DeepSeek进行写作。

注意 **不要给DeepSeek一个太过“抽象”和“理论”的问题**，比如，“请给我取一个有关美食的有吸引力的标题”，美食、有吸引力？这个范围可太大了，会出现各种各样的标题，但是并不一定符合你的账号定位和笔记内容。

### 应该怎么问？

**添加背景信息（这篇笔记的核心内容、目标、面向的受众、账号风格）；输出格式（语气、风格、必须含有的关键词、字数）。**

例如下面的对话，我的提示语是“请给我的小红书口红色号测评笔记取一个吸引人的标题，我是黄皮素颜测评的，笔记目的是为黄皮找到合适的口红色号，标题有趣生动，必须含有关键词‘黄皮’和‘口红’”，模型给出了好几种类型的标题，无论是“直击痛点”、“夸张效果”还是“数字盘点型”，都是非常具有吸引力的，并且标题也满足了我的所有要求，非常好用。

![img](https://pic.yupi.icu/yuyi/1739499899654-443271b0-20ef-42e6-aea8-c6a163990533.webp)

## 文案写作

写文案需要考虑的因素就更多了，你的问题直接导致了文案的要点、深度、风格等等，**如果问题过于简洁，或者表述不明，那么生成的文案也是很难满意的，** 比如你问“请给我生成一篇护肤技巧的小红书笔记文案，”护肤包含的内容可太多了，护肤手法、时间、护肤品使用、不同肤质的护肤注意事项……你不说，DeepSeek是没法猜到你内心想要的东西的。

**所以以下这些内容，都是可以放进问题里的：**

**①文案的主题、目的和面向的目标受众**，例如“我需要写一篇关于‘秋季护肤小贴士’的小红书笔记，目标受众是20-35岁的女性用户。”

**②详细背景与要求**，例如“笔记内容应包含秋季护肤的重要性、适合秋季的护肤品推荐（至少三款）、个人使用体验分享以及结尾的互动呼吁（如邀请用户留言分享自己的秋季护肤心得）”。

**③输出的文案必须包含的要点、风格、排版、符号等。** 例如“笔记必须包含实操步骤，笔记语言通俗易懂，可以加入一些搞笑元素，文章要用符号分点，排版整齐。”

将以上这些提示语整合后输入，DeepSeek就可以输出一篇完整的小红书笔记文案。

![img](https://pic.yupi.icu/yuyi/1739499900022-1476a4e6-b6fc-453c-b25e-7d115abd333a.webp)

## 生成图片

### （1）输入文字

想要生成一张图片，首先我们要用文字详细描述，包含多种要素和输出要求：

**①图片元素：** 图片中的主要对象或场景，如人物、动物、风景、描述对象的特征，如动作、装扮、形态，如果有多个对象，还要说明他们的布局和关系。

**②背景与场景：** 说明图片的背景内容，如纯色背景、教室背景、草原背景，如果背景中还有固定元素，如云朵、树木、建筑物等，也需要详细描述。

**③风格与色彩：** 描述图片的整体风格，如小清新、卡通等，并且规定图片色彩和色调，如冷暖色调、蓝色调，使用暖黄色、纯白色。

**④图片格式：** SVG、PNG、JPG；图片尺寸；图片分辨率。

**⑤其他细节：** 还可以说明图片的用途或场景，以便DeepSeek更好地理解需求。

例如下图的一段文字，就包含了图片主题、各个元素，图片风格、格式等等。

![img](https://pic.yupi.icu/yuyi/1739499900113-6fdb6570-c605-40e3-aedd-92d2eec96341.webp)

### （2）选择输出格式

①优化文字

在文字末尾加上 **“请帮我生成AI绘画提示词”** ，DeepSeek就会生成一段优化后的文字，**将优化后的文本内容复制** 下来，**选择一个文生图 AI 模型**（如Midjourney、即梦AI、Stable Diffusion等），将文本内容粘贴进去，根据所选模型的提示和要求，调整图片的风格、格式等细节，就可以生成图片了。

![img](https://pic.yupi.icu/yuyi/1739499900245-561fd391-d008-4928-b7d5-544c8987c133.webp)

![img](https://pic.yupi.icu/yuyi/1739499900050-7121c791-3cf4-4707-9fb1-fbac85bb6fe4.webp)

**②** 生成HTML代码

在文字末尾加上 **“配图用HTML格式制作”**， DeepSeek就会生成相应的HTML代码，将代码复制到记事本，或者vscode 等软件，保存为html文件格式，用浏览器即可打开，查看生成的图片。

![img](https://pic.yupi.icu/yuyi/1739499900053-ac65abce-ebae-4cd8-a06a-7a12b431d2ae.webp)



## 数据分析

当小红书博主某篇笔记数据差，却找不到具体原因，可以用DeepSeek做数据分析，找不足和改进的方法，但要 **避免只提供单一维度的数据**，比如仅靠一个笔记阅读量提问为什么变差，影响笔记阅读量的原因是非常多的，生成的答案范围广，看了等于白看，仍然找不到原因。

所以需要 **将笔记详细数据，包括但不限于账号粉丝量、笔记数量，往期笔记数据和本篇笔记数据以及我们上面提到的这些“背景信息”：账号定位、细分类目发布时间等等，使用“请分析数据反映出这篇笔记有什么不足之处？”的指令，就能得到一则对某篇笔记的详细分析。**

例如下图的示例，将零食测评笔记的详细数据列举出来，询问此篇笔记存在的问题，模型通过数据分析给出了此篇笔记的表现情况和可能存在的问题，还给出了针对性的解决方案。

![img](https://pic.yupi.icu/yuyi/1739499900463-f7924e5e-6318-42ac-9073-df5d1639dd4a.webp)

## 账号运营

**不管是刚刚起号的新人博主，还是已经运营了多年的账号，都可以向DeepSeek寻求账号运营方面的答案。就相当于让DeepSeek“诊脉”，注意避免输出的问题信息单一、陈旧。**

例如只说账号流量差，但却没有说明自己的粉丝量多少，如果你只是一个刚起步的账号，这个情况属于正常，却让DeepSeek一通分析可能的原因，那也是抓不住根本的。

例如最近笔记数据不佳，博主就可以将自己的账号情况说明，包括 **账号定位、粉丝量、粉丝画像、最近笔记发布时间和频率、内容、数据情况（背景信息）写进问题里，** 回答分析了所有可能性，方便博主对比观察，在这些问题中找到自己的不足之处，同时模型还给出了实操方案，还是非常实用的。

![img](https://pic.yupi.icu/yuyi/1739499900467-472921a6-4620-4dd5-bfd3-c972c793665d.webp)

以上就是一整套用DeepSeek做小红书的流程和方法，不得不说，DeepSeek等 AI 工具的出现是为做小红书带来了极大的便利，可以帮助创作者高效完成笔记，甚至文笔和创意也不输人类，用好了是一举两得的好事！

但人类的创造力、情感共鸣和审美力都是 AI 不可取代的，这也是人类和 AI 相比的核心竞争力，要知道，**AI 输出的内容终究还是在人类成果基础上生成的，所以，享受这份便利，同时也要一直感受、思考和表达。**



> 来源：https://mp.weixin.qq.com/s/eMj3JHpAjikL4JUXzj8yXQ